x<-read.csv("http://canisius.edu/~yany/data/ibmMonthly.csv")

 head(x,3)
 p<-x$Adj.Close
 n<-length(p)
 n
 ret<-p[2:n]/p[1:(n-1)]-1
 head(ret)
 stdMonthly<-sd(ret)
 stdAnnual<-sqrt(12)*stdMonthly
 stdAnnual

x<-read.csv("http://canisius.edu/~yany/data/ibmDaily.csv")

 head(x,3)
 p<-x$Adj.Close
 n<-length(p)
 n
 ret<-p[2:n]/p[1:(n-1)]-1
 head(ret)
 stdDaily<-sd(ret)
 stdAnnual<-sqrt(252)*stdDaily
 stdAnnual




r<-retD50 # simplify the notation
ibm<-subset(r,r[,1]=="IBM" &format(r[,2],"%Y")=="2010")
ind<-subset(sp500,format(sp500[,1],"%Y")=="2010")
a<-data.frame(ibm[,2],ibm[,3])
colnames(a)<-c("date","Ri")
k<-merge(a,ind,by="date") # merge by date
y<-k$Ri # get dependent variable
x<-k$mkt # get independent variable
lm(y~x) # lm() for linear model



dailyRet<-function(ticker){
   path<-paste("http://canisius.edu/~yany/data/",ticker,'Daily.csv',sep='')
   x<-read.csv(path,header=T)
   ddate<-as.Date(x[,1])
   n<-nrow(x)
   p<-x[,6]
   ret<-p[2:n]/p[1:(n-1)]-1
   final<-data.frame(ddate[2:n],ret,stringsAsFactors=F)
   colnames(final)<-c("DATE","RET")
   return(final)
}


beta_f<-function(ticker,year=2000){
  stock<-dailyRet(ticker)
   mkt<-dailyRet("^gspc")
   colnames(mkt)<-c('DATE','MKT')
   data<-merge(stock,mkt)
   d2<-subset(data,format(data[,1],"%Y")==year)
   beta<-round(coef(lm(d2$RET~d2$MKT))[2],digits=4)
   show(paste('Beta for ',ticker,'in',year,'=',beta))
}




con<-url("http://canisius.edu/~yany/RData/ibmMonthly.RData")
load(con)

> con<-url("http://canisius.edu/~yany/RData/ibmMonthly.RData")
> load(con)
> head(.ibmMonthly)
        DATE     OPEN     HIGH      LOW    CLOSE ADJ.CLOSE   VOLUME
1 1962-01-01 7.713333 7.713333 7.003334 7.226666  2.056971  8760000
2 1962-02-01 7.300000 7.480000 7.093333 7.160000  2.037994  5737600
3 1962-03-01 7.186666 7.413333 7.070000 7.103333  2.022141  5344000
4 1962-04-01 7.100000 7.100000 6.000000 6.053333  1.723233 12851200
5 1962-05-01 6.053333 6.530000 4.733333 5.233333  1.489798 49307200
6 1962-06-01 5.213333 5.213333 4.000000 4.523334  1.287883 68451200


return_f<-function(data){
   ddate<-as.Date(data[,1])
   n<-nrow(data)
   p<-data[,6]
   ret<-p[2:n]/p[1:(n-1)]-1
   final<-data.frame(ddate[2:n],ret,stringsAsFactors=F)
   colnames(final)<-c("DATE","RET")
   return(final)
}


 con<-url("http://canisius.edu/~yany/RData/sp500monthly.RData")
 load(con)
 sp500<-return_f(.sp500monthly)




