ST_path_f<-function(S,r,T,n,sigma){
    delta_T<-T/n
    ST<-seq(1:n)*0
    ST[1]<-S
    for (i in 2:n){
       temp1<-r-0.5*sigma*sigma*delta_T
       temp2<-sigma*rnorm(1)*sqrt(delta_T)
       ST[i]<-ST[i-1]*exp(temp1+temp2)
   }
   return(ST)
}


asianCallAveragePrice<-function(s,x,r,T,sigma,n_steps,n_trial){
     payoff<-payoff<-rep(0,time=n_trial) # initialization
     for(i in 1:n_trial){
        Saverage<- mean(ST_path_f(s,r,T,n_steps,sigma))
        payoff[i]<-max(Saverage-x,0)
    }
    return(mean(payoff)*exp(-r*T))
}

set.seed(12345)
asianCallAveragePrice(50,50,0.01,0.5,0.2,100,500)


