weights_zero_risk2stock_port<-function(sigma1,sigma2,rho){
    " > weights_zero_risk2stock_port(0.1,0.2,-1)
      x1 x2
     [1,] 1.651 -0.651
     [2,] 0.418 0.582
    "
    x<-matrix(NA,2,2)
    a<-sigma1^2 + sigma2^2 -2*rho*sigma1*sigma2^2
    b<-2*rho*sigma1*sigma2 - 2*sigma2^2
    c<-sigma2^2
    if(b^2<4*a*c) {
          stop("no solution")
    } else{
      x[1,1]<- (-b+sqrt(b^2-4*a*c))/(2*a)
      x[1,2]<-1-x[1,1]
      x[2,1]<- (-b -sqrt(b^2-4*a*c))/(2*a)
      x[2,2]<-1-x[2,1]
   }
   colnames(x)<-c("x1","x2")
   return(round(cbind(x),digits=3))
}

